globals [ thehand activeguide oldguide move-done headingsetup history verbose?
          phase loops key ktype ksize sequence color-by-move matrix_size loop-start]
breed [ dots dot ]
breed [ hands hand ]
breed [ guides guide ]
guides-own [ pos move ]
hands-own [ pos location old-location ]

to new-artist
  set artist user-input "enter artist's name:"
  ;user-message (word "Now, please make a folder for " artist ":")
  ;let dir user-directory
  set Kolam-Name ""
  set kolam-number 1
  set GPS "000"
  set kolam-task "-"
  set difficulty "-"
  setup
end


to setup
  ;; (for this model to work with NetLogo's new plotting features,
  ;; __clear-all-and-reset-ticks should be replaced with clear-all at
  ;; the beginning of your setup procedure and reset-ticks at the end
  ;; of the procedure.)
  __clear-all-and-reset-ticks                                                                             ; Background
  set matrix_size round (world-width / (Pulli + 1))
  ask patches with [pxcor mod matrix_size = 0 and pycor mod matrix_size = 0] [sprout-dots 1]
  ask dots with [pxcor = 0 or pycor = 0 or pycor >= matrix_size * (Pulli + 1) or pxcor >= matrix_size * (Pulli + 1)] [die]
  ask dots [ set color black  set shape "circle"  set size matrix_size / 15 ]
  ask patches [ set pcolor white ]

  create-hands 1                                                                  ; The Hand
      [ set ycor matrix_size / 2  set xcor 0  set color draw-color   set heading 90
        set label-color red     set size 5  set pen-size matrix_size / 6   set pos "Ov"    pen-down ]
    set thehand min-one-of hands [who]

  set activeguide one-of dots                                                     ; Initialize Vars
  set color-by-move false
  set oldguide thehand
  ask thehand [ set location int (xcor * 10000 + ycor * 100 + heading)    set old-location location ]
  set move-done FALSE
  set headingsetup FALSE
  set phase "move"
  set verbose? FALSE
  set inserted-list ""
  set loops 1
  set loop-start []
  set ktype "______"
  set ksize 0
  set key "null"
  set sequence [ [] ]
  set history [["history-array"]["Oldx"]["Oldy"]["Oldh"]["Oldpos"]]
  clear-undo-cache
  file-close
  ;record history of hand states
  let templist lput ([xcor] of thehand) (item 1 history)     set history replace-item 1 history templist
  set templist lput ([ycor] of thehand) (item 2 history)     set history replace-item 2 history templist
  set templist lput ([heading] of thehand) (item 3 history)  set history replace-item 3 history templist
  set templist lput ([pos] of thehand) (item 4 history)      set history replace-item 4 history templist
end


to go-guides
  if phase = "move" [                                         ; EITHER MOVE hand, set heading
    if mouse-down?  [ ask thehand
        [ pen-up
          ask guides [ die ]
          let tempx mouse-xcor - (mouse-xcor mod (matrix_size / 2))
          let tempy mouse-ycor - (mouse-ycor mod (matrix_size / 2))
          let OrthoX? FALSE  ; might not need this with heading info!
          let OrthoY? FALSE
            if tempx mod matrix_size = 0 [ set OrthoX? TRUE ]
            if tempy mod matrix_size = 0 [ set OrthoY? TRUE ]
            if OrthoX? and OrthoY?   ; if hand is on dot; move right.
            [ set tempx tempx + matrix_size / 2  set pos "Oh" ]
            if OrthoX? and NOT OrthoY?         [ set pos "Ov" ]
            if NOT OrthoX? and OrthoY?         [ set pos "Oh" ]
            if NOT OrthoX? and NOT OrthoY?     [ set pos "D"  ]
          setxy tempx tempy
          pen-down
          set move-done TRUE      ]  ]
     if move-done and NOT mouse-down? [ set phase "head" set move-done FALSE]     ]

  if phase = "head" [ ask thehand                         ; ALIGN the hand
    [ if not any? guides
      [ if member? "O" pos  [ let angle 45  repeat 4
          [ hatch-guides 1 [set heading angle  pen-up  fd matrix_size  set pos "HEADING"]
            set angle angle + 90] ]
        if member? "D" pos  [ let angle 0   repeat 4
          [ hatch-guides 1 [set heading angle  pen-up  fd matrix_size  set pos "HEADING"]
            set angle angle + 90] ]
        ask guides [ set color red - 2 set size 2]
        set headingsetup TRUE   ]

    let heading-guides guides with [pos = "HEADING" ]

      if headingsetup
        [ set oldguide activeguide
          set activeguide min-one-of heading-guides [distancexy mouse-xcor mouse-ycor]
          if activeguide != oldguide
            [ ask links [die]
              ask heading-guides [set label ""]
              create-link-with activeguide [set color grey + 3 ]
              ask activeguide [ set label-color red set label heading ]
              set heading [heading] of activeguide
              set oldguide activeguide      ]
          if mouse-down? [ set phase "pre-guide" ask guides [die]  set headingsetup FALSE ]

       if key != "null"
        [ let deg 9999
          ifelse [pos] of thehand = "D"
            [ if key = "1" [set deg 0]
              if key = "2" [set deg 90]
              if key = "3" [set deg 180]
              if key = "4" [set deg 270]  ]
            [ if key = "1" [set deg 45]
              if key = "2" [set deg 135]
              if key = "3" [set deg 225]
              if key = "4" [set deg 315]  ]

           set heading deg
           set activeguide one-of guides with [ heading = deg ]
           set oldguide activeguide
           set key "null"
           set phase "pre-guide" ask guides [die]  set headingsetup FALSE ]
               ]  ;END if headingsetup
      ]  ]  ;END phase = "head"

  if phase = "pre-guide" and NOT mouse-down? [ set phase "guide" ]

  if phase = "guide"                                ; OR DRAW with guides
    [ ask thehand [ set old-location location  set location int (xcor * 10000 + ycor * 100 + heading)
      if location != old-location or not any? guides [ hatchguides ] ]
      set activeguide min-one-of guides [ distancexy mouse-xcor mouse-ycor ]
      ask guides [set label "" ]
      ask activeguide [set label move set label-color red ]
      if oldguide != activeguide and (mouse-down? and ([distancexy mouse-xcor mouse-ycor] of activeguide < (matrix_size / 6)))
         [ draw-to activeguide TRUE ]

      if key != "null"
        [ let guides-avail count guides with [ member? key move ]
          if guides-avail > 1
             [ ask guides with [ not member? key move ] [die]
               if not any? guides [hatchguides  print "wierd!" ]   ]
           if guides-avail = 1
             [ set activeguide one-of guides with [ member? key move ]
               draw-to activeguide TRUE]
          if guides-avail < 1
             [ print (word "No available moves match '" key "'.") ]
          set key "null"     ]

      ifelse phase = "guide" [set phase "post-guide"] [ ask guides [die] ]   ]

  if phase = "post-guide" and NOT mouse-down? [ set phase "guide" ]
end



to hatchguides              ; guides present moves to user/thehand
 ask guides [die]
 let posn [pos] of thehand
 let head [heading] of thehand

  if member? "O"  posn    ; from ORTHOGONAL...
   [ foreach [1 2 3 4]                               ;  ORTHOGONAL options FROM ORTHO
       [ [?1] -> ask thehand [ hatch-guides 1 [ dress-thyself  fd matrix_size * sqrt(2) / 2
         if member? "Oh" posn [ repeat (?1 - 1)
               [ ifelse head = 135 or head = 315 [left 90] [right 90] fd matrix_size * sqrt(2) / 2  ]
               set pos "Oh"   if ?1 = 1 or ?1 = 3 [ set pos "Ov" ]  ]
         if member? "Ov" posn [ repeat (?1 - 1)
               [ ifelse head = 135 or head = 315 [right 90] [left 90] fd matrix_size * sqrt(2) / 2  ]
               set pos "Ov"   if ?1 = 1 or ?1 = 3 [ set pos "Oh" ]  ]
         set move word "O" ?1 ]  ]  ]

                                                       ;  TRANSITIONAL options FROM ORTHO
     ask guides with [member? "O" pos ] [ hatch-guides 1 [ dress-thyself
         if member? "Oh" posn
               [ ifelse (head = 135 or head = 315) [left 45] [right 45] fd matrix_size / 2 ]
         if member? "Ov" posn
               [ ifelse (head = 135 or head = 315) [right 45] [left 45] fd matrix_size / 2 ]
         set move replace-item 0 move "T"  set pos "D"  ]  ]


    ask thehand [ hatch-guides 3                      ;  CENTER options FROM ORTHO
       [ dress-thyself
         if member? "Oh" posn
               [ ifelse (head = 135 or head = 315) [left 45] [right 45] fd matrix_size / 2 ]
         if member? "Ov" posn
               [ ifelse (head = 135 or head = 315) [right 45] [left 45] fd matrix_size / 2 ]
         set move "C"  set pos "C"]  ]
    ask one-of guides with [move = "C"] [ set move "C1" ]
    ask one-of guides with [move = "C"] [ set move "C2" ]
    ask one-of guides with [move = "C"] [ set move "C3" ]

    ask thehand [ hatch-guides 1                      ;  Point option FROM ORTHO
       [ dress-thyself
         if member? "Oh" posn
               [ ifelse (head = 135 or head = 315) [left 45] [right 45] fd matrix_size * 1.5  set pos "Oh"]
         if member? "Ov" posn
               [ ifelse (head = 135 or head = 315) [right 45] [left 45] fd matrix_size * 1.5  set pos "Ov"]
         set move "OP" ]  ]

    ask thehand [ hatch-guides 1                      ;  Horns A options FROM ORTHO
    [ dress-thyself
      if member? "Oh" posn
         [ ifelse (head = 135 or head = 315) [lt 45 set move "H3L"] [rt 45 set move "H3R"]  set pos "Oh" ]
      if member? "Ov" posn
         [ ifelse (head = 135 or head = 315) [rt 45 set move "H3R"] [lt 45 set move "H3L"]  set pos "Ov" ]
      fd matrix_size * 1.5 ]  ]

    ask thehand [ hatch-guides 1                      ;  Horns B options FROM ORTHO
       [ dress-thyself
         if member? "Oh" posn [ ifelse (head = 45 or head = 225)
                   [left  45  fd matrix_size  right 90 fd matrix_size / 2  left  90 set move "H3L" ]
                   [right 45  fd matrix_size  left  90 fd matrix_size / 2  right 90 set move "H3R" ]
                set pos "Oh"]
         if member? "Ov" posn [ ifelse (head = 45 or head = 225)
                   [right 45  fd matrix_size  left  90 fd matrix_size / 2  right 90 set move "H3R" ]
                   [left  45  fd matrix_size  right 90 fd matrix_size / 2  left  90 set move "H3L" ]
                set pos "Ov"]  ]  ]

   ]

  if member? "D" posn      ; from DIAGONAL position...
   [ ask thehand [                                                                ; create D moves
     hatch-guides 1 [ dress-thyself  fd matrix_size set pos "D"  set move "D1" ]  ; d1

     foreach [2 3 4]
      [ [?1] -> hatch-guides 1 [ dress-thyself  fd matrix_size                            ; Right d2, d3, d4
        repeat (?1 - 1) [ right 90 fd matrix_size] set pos "D" set move (word "D" ?1 "R")]
        hatch-guides 1 [ dress-thyself  fd matrix_size                            ; Left  d2, d3, d4
        repeat (?1 - 1) [ left 90 fd matrix_size]  set pos "D" set move (word "D" ?1 "L")]  ]

     foreach [1 2 3 4]                                                            ; create T moves
      [ [?1] -> hatch-guides 1 [ dress-thyself  fd matrix_size / 2  right 45 fd matrix_size * sqrt(2) / 2
        repeat (?1 - 1) [ right 90 fd matrix_size * sqrt(2) / 2]
          if head mod 180 = 0 [ ifelse ?1 mod 2 = 0 [set pos "Oh"] [set pos "Ov"] ]
          if (head - 90) mod 180 = 0  [ ifelse ?1 mod 2 = 0 [set pos "Ov"] [set pos "Oh"] ]
        set move (word "T" ?1 "R")]
        hatch-guides 1 [ dress-thyself  fd matrix_size / 2   left 45 fd matrix_size * sqrt(2) / 2
        repeat (?1 - 1) [ left 90 fd matrix_size * sqrt(2) / 2]
          if head mod 180 = 0 [ ifelse ?1 mod 2 = 0 [set pos "Oh"] [set pos "Ov"] ]
          if (head - 90) mod 180 = 0  [ ifelse ?1 mod 2 = 0 [set pos "Ov"] [set pos "Oh"] ]
        set move (word "T" ?1 "L")]  ]
   ]  ]
end


to draw-to [target update-output?]
  let text [move] of target

;record history of hand states
  let templist lput ([xcor] of thehand) (item 1 history)     set history replace-item 1 history templist
  set templist lput ([ycor] of thehand) (item 2 history)     set history replace-item 2 history templist
  set templist lput ([heading] of thehand) (item 3 history)  set history replace-item 3 history templist
  set templist lput ([pos] of thehand) (item 4 history)      set history replace-item 4 history templist

;check if move is at the start of a loop
  if length last sequence = 0
     [ set loop-start [0 1 2 3]
     set loop-start replace-item 0 loop-start [xcor] of thehand
     set loop-start replace-item 1 loop-start [ycor] of thehand
     set loop-start replace-item 2 loop-start [heading] of thehand
     set loop-start replace-item 3 loop-start [pos] of thehand ]

;execute manuever
  if member? "O" text [ o target set ktype replace-item 0 ktype "O" ]    ;Orthogonal
  if member? "D" text [ d target set ktype replace-item 1 ktype "D" ]    ;Diagonal
  if member? "T" text [ t target set ktype replace-item 2 ktype "T" ]    ;Transitional
  if member? "C" text [ c target set ktype replace-item 3 ktype "C" ]    ;Circle
  if member? "H" text [ h target set ktype replace-item 4 ktype "H" ]    ;Horn
  ;if member? "B" text [ b target set ktype replace-item 5 ktype "B" ]    ;Base

;update global Kolam Data
  set ksize ksize + 1
  set oldguide activeguide
  let current-loop lput text (item (loops - 1) sequence)
  set sequence replace-item (loops - 1) sequence current-loop
  if update-output? = TRUE [display-sequence]

;check if move is at the end of a loop (returned to the start place)
   if  abs ( item 0 loop-start - [xcor] of thehand ) < 0.3
   and abs ( item 1 loop-start - [ycor] of thehand ) < 0.3
   and item 2 loop-start = [heading] of thehand
   and item 3 loop-start = [pos] of thehand
        [ next-loop ]

;save a snapshot for UNDO
  ask guides [die] ask thehand [set hidden? TRUE]
  let title word "Undo/" ksize
  export-view (word title ".png")
  ask turtles [set hidden? FALSE]
end



; ######################################## FEATURES ##################################################
; ######################################## FEATURES ##################################################
; ######################################## FEATURES ##################################################



to undo
ifelse ksize > 1 [
  import-drawing (word "Undo/" (ksize - 1) ".png")
  file-delete (word "Undo/" ksize ".png")
  set ksize ksize - 1

;clean empty loops out of sequence
  foreach sequence
    [ [?1] -> if empty? ?1 [ set sequence remove ?1 sequence ] ]
  set loops length sequence
  let current-loop but-last (item (loops - 1) sequence)
  set sequence replace-item (loops - 1) sequence current-loop
  display-sequence

;reverse history of hand states by 1
  ask thehand [ pen-up ]
  ask thehand [ set xcor last item 1 history]
  ask thehand [ set ycor last item 2 history]
  ask thehand [ set heading last item 3 history]
  ask thehand [ set pos last item 4 history]
  ask thehand [ pen-down ]
  foreach [1 2 3 4]
    [ [?1] -> let temp-list but-last (item ?1 history)
      set history replace-item ?1 history temp-list ]
  refresh-ktype  ]
  [setup]
end

to refresh-ktype
  set ktype "______"
  let mashup butlast word sentence sequence ";" ";"
  if member? "O" mashup [set ktype replace-item 0 ktype "O" ]
  if member? "D" mashup [set ktype replace-item 1 ktype "D" ]
  if member? "T" mashup [set ktype replace-item 2 ktype "T" ]
  if member? "C" mashup [set ktype replace-item 3 ktype "C" ]
  if member? "H" mashup [set ktype replace-item 4 ktype "H" ]
  if member? "B" mashup [set ktype replace-item 5 ktype "B" ]
end


to clear-undo-cache
  let file-ticker 0
  let title (word "Undo/" file-ticker ".png")
  repeat 401 [
      if file-exists? title [ file-delete title ]
      set file-ticker file-ticker + 1
      set title (word "Undo/" file-ticker ".png")  ]
end



to save-kolam
ifelse (GPS = "000") or (artist = "") or (kolam-number = 0)
  [user-message "Please set the GPS, artist and Kolam-number fields before saving.  Thanks."] [

;clean empty loops out of sequence
  foreach sequence [ [?1] -> if empty? ?1 [ set sequence remove ?1 sequence ] ]
  set loops length sequence

;Prepare for Save
  let date-time date-and-time
  let grid-size round (max-pxcor * 2 / matrix_size)
  let title (word  GPS "-" artist "-" kolam-task "." kolam-number "-m" ksize)
  if Kolam-Name != "" [set title (word title "-" Kolam-Name)]
  if initials != "" [set title (word title "-" initials)]
  ask guides [set hidden? TRUE] ask thehand [set hidden? TRUE]

;Check if the artist's folder already exists
;  if file-exists? (word "Saved/" artist "/") = FALSE
;    [ file-open (word "Saved/" artist "/")  ]

;Execute the Save
  export-view (word "Saved/" title ".png")   ; save everything
  file-open (word "Saved/" title ".txt")
    file-print "\"Saved Kolam\""
    file-print "\"matrix_size\""
    file-print matrix_size
    file-print ""
    file-print "\"sequence\""
    file-write sequence
    file-print ""
    file-print "\"history\""
    file-write history
    file-print ""
    file-print "\"date-time\""
    file-write date-time
    file-print ""
    file-print "\"Pulli\""
    file-write Pulli
    file-print ""
    file-print "\"Loops\""
    file-write loops
    file-print ""
    file-print "\"Manuever Classes (ktype)\""
    file-write ktype
    file-print ""
    file-print "\"GPS\""
    file-write GPS
    file-print ""
    file-print "\"artist\""
    file-write artist
    file-print ""
    file-print "\"kolam-task\""
    file-write kolam-task
    file-print ""
    file-print "\"kolam-number\""
    file-write kolam-number
    file-print ""
    file-print "\"difficulty\""
    file-write difficulty
   file-close
  ask turtles [set hidden? FALSE]
    ]
end


to load-kolam
;load file
  ;set-current-directory "Saved Kolams/"
  file-open user-file
  let tmpvar file-read
  ifelse tmpvar = "Saved Kolam" [print tmpvar][print "Not a proper Saved Kolam!" file-close stop]
  ifelse file-read = "matrix_size"
    [set matrix_size file-read print word "matrix_size: " matrix_size]
    [print "matrix_size variable not on line 3" file-close stop]
  ifelse file-read = "sequence"
    [set sequence read-from-string file-read-line print word "sequence: " sequence ]
    [print "sequence variable not on line 5" file-close stop]
  ifelse file-read = "history"
    [set history read-from-string file-read-line print word "history: " history ]
    [print "history variable not on line 7" file-close stop]
  let junk file-read
  set junk file-read
  ifelse file-read = "Pulli"
    [set Pulli read-from-string file-read-line print word "Pulli: " Pulli ]
    [print "Pulli variable not on line 11" file-close stop]
  ;set-current-directory "/"
  file-close

;Initialize
  cp ct cd
  ask patches [ set pcolor red - 2 ]
  ask patches with [pxcor mod matrix_size = 0 and pycor mod matrix_size = 0]
      [ sprout-dots 1  [ set color white  set shape "circle"  set size matrix_size / 6 ] ]
  create-hands 1
      [ set ycor matrix_size / 2  set xcor 0  set color draw-color  set size 5  set pen-size matrix_size / 6  ]
  set thehand min-one-of hands [who]
  set activeguide one-of dots
  set oldguide thehand

;correct variables
  foreach sequence  [ [?1] -> if empty? ?1 [ set sequence remove ?1 sequence ] ]
  set loops length sequence
  refresh-ktype
  let tempseq []
  foreach sequence [ [?1] -> set tempseq sentence tempseq ?1 ]
  let final-ksize length tempseq
  clear-undo-cache
  let saved-sequence sequence
  let saved-history history
  set sequence [ [] ]
  set loops 1
  set ksize 0
  set key "null"

  display-sequence

;execute saved kolam steps
  repeat final-ksize [
    ask thehand [ pen-up
      set xcor item (ksize + 2) item 1 history
      set ycor item (ksize + 2) item 2 history
      set heading item (ksize + 2) item 3 history
      set pos item (ksize + 2) item 4 history
      pen-down ]

    no-display
    hatchguides
    set activeguide one-of guides with [move = item ksize tempseq]
    draw-to activeguide FALSE ; draw-to increments ksize
    display    ]

    set sequence saved-sequence
    set history saved-history
    display-sequence

;set these at very end
  set move-done FALSE
  set headingsetup FALSE
  set phase "move"
end



to paste-loop
;pick loop
  foreach sequence  [ [?1] -> if empty? ?1 [ set sequence remove ?1 sequence ] ]
  set loops length sequence
  display-sequence
  let looplist []
  let numloops 1
  repeat length sequence [ set looplist lput numloops looplist  set numloops numloops + 1 ]
  set looplist item ((user-one-of "! Check Location !  Which loop to duplicate?" looplist) - 1) sequence
  set sequence lput [] sequence
  set loops length sequence

;execute loop list
  foreach looplist [ [?1] ->
      no-display
      hatchguides
      let movetext ?1
      set activeguide one-of guides with [move = movetext]
      draw-to activeguide FALSE
      display ]
  display-sequence

;set phase to move, because a full loop was just completed.
  set move-done FALSE
  set headingsetup FALSE
  set phase "move"
end


to delete-loop
;pick loop
  set loops length sequence
  let d-loop []
  let numloops 1
  repeat length sequence [ set d-loop lput numloops d-loop  set numloops numloops + 1 ]
  set d-loop (user-one-of "! Check Location !  Which loop to duplicate?" d-loop) - 1
  set sequence remove-item d-loop sequence
  set loops length sequence
  display-sequence

;set phase to move, because a full loop was just completed.
  set move-done FALSE
  set headingsetup FALSE
  set phase "move"
end




to paste-moves [backwards?]
;acquire list from userbox, default nicely
  let newlist read-from-string inserted-list
  ifelse not is-list? newlist [ print "ERROR!  inserted list of moves not parsing as a list!" ]
  [
  if backwards? = TRUE [ set newlist reverse newlist]

  ;execute loop list
    foreach newlist [ [?1] ->
        no-display
        hatchguides
        let movetext ?1
        set activeguide one-of guides with [move = movetext]
        draw-to activeguide FALSE
        display ]
    display-sequence

  ;set phase to move, because a full loop was just completed.
    set move-done FALSE
    set headingsetup FALSE
    set phase "move"
  ]
end



; ######################################## MOVES ##################################################
; ######################################## MOVES ##################################################
; ######################################## MOVES ##################################################



to c [target]
  let movetext [move] of target
  let posn [pos] of thehand
  let head [heading] of thehand

  ifelse color-by-move [ ask thehand [ set color draw-color ]] [ ask thehand [ set color draw-color ] ]

  if member? "1" movetext [                            ; c1 - CIRLCE
    let radius matrix_size * sqrt(2) / 4
    let circ (pi * radius * 2)                          ; circumference
    let degree-step (circ / 360)                        ; step per degree of turn
    ask thehand [penup fd matrix_size * sqrt(2) / 4 pendown
    repeat 360 [fd degree-step
            if member? "Ov" posn [ ifelse head = 135 or head = 315 [right 1] [left 1]  ]
            if member? "Oh" posn [ ifelse head = 135 or head = 315 [left 1]  [right 1] ] ]
    penup bk matrix_size * sqrt(2) / 4 pendown
    set location location + 1 ]   ]

    if member? "2" movetext [                            ; c2 - STAR
      ask thehand [ let oldh heading  let oldy ycor let oldx xcor
      let star-size matrix_size / 5
      pu setxy [xcor] of target [ycor] of target set heading 0 pd
        repeat 8 [ fd star-size bk star-size rt 45 ]
      pu setxy oldx oldy set heading oldh pd
      ] ]

    if member? "3" movetext [                            ; c2 - SWASTIK
      ask thehand [ let oldh heading  let oldy ycor let oldx xcor
      let swa-size matrix_size / 5
      pu setxy [xcor] of target [ycor] of target set heading 0 pd
        repeat 4 [ fd swa-size rt 90 fd swa-size pu
                   setxy [xcor] of target [ycor] of target pd ]
      pu setxy oldx oldy set heading oldh pd
      ] ]


end




to t [target]
  let movetext [move] of target
  let head [heading] of thehand
  let radius matrix_size * sqrt(2) / 4
  let circ (pi * radius * 2)                          ; circumference
  let degree-step (circ / 360)                        ; step per degree of turn
  let tx [xcor] of target let ty [ycor] of target let th [heading] of target
  if (degree-step > 10) or (degree-step < 0)  [print (word "Bad Arc! degree-step: " precision degree-step 2 ) stop]

  ask thehand [

  ifelse color-by-move [ set color red ] [ set color draw-color ]

  if member? "O" pos                                       ; O to D transitions
    [ set radius matrix_size * sqrt(2) / 4
      set degree-step ((pi * radius * 2) / 360)

     if member? "1" movetext [ draw-arc-to target ]       ; t1

      if member? "2" movetext [                            ; t2
        fd matrix_size * sqrt(2) / 4
        repeat 90 [ fd degree-step                         ; rotate 90
            if member? "Oh" pos [ ifelse head = 135 or head = 315 [left 1] [right 1] ]
            if member? "Ov" pos [ ifelse head = 135 or head = 315 [right 1] [left 1] ] ]
        draw-arc-to target ]

      if member? "3" movetext [                            ; t3
        fd matrix_size * sqrt(2) / 4
        repeat 180 [ fd degree-step                         ; rotate 180
            if member? "Oh" pos [ ifelse head = 135 or head = 315 [left 1] [right 1] ]
            if member? "Ov" pos [ ifelse head = 135 or head = 315 [right 1] [left 1] ] ]
        draw-arc-to target ]

      if member? "4" movetext [                            ; t4
        fd matrix_size * sqrt(2) / 4
        repeat 270 [ fd degree-step                         ; rotate 270
            if member? "Oh" pos [ ifelse head = 135 or head = 315 [left 1] [right 1] ]
            if member? "Ov" pos [ ifelse head = 135 or head = 315 [right 1] [left 1] ] ]
        draw-arc-to target ]

        ;is there a t5?

    ]
  if member? "D" pos                                       ; D to O transitions
    [ set radius matrix_size * sqrt(2) / 2
      set degree-step ((pi * radius * 2) / 360)
      if member? "R" movetext [ hatch-guides 1 [ pu rt 45 fd matrix_size * sqrt(2) / 2
          lt 90 fd matrix_size * sqrt(2) / 4 rt 90 set pos "g1"] ]
      if member? "L" movetext [ hatch-guides 1 [ pu lt 45 fd matrix_size * sqrt(2) / 2
          rt 90 fd matrix_size * sqrt(2) / 4 lt 90 set pos "g1"] ]
      let g1 one-of guides with [pos = "g1"]

      if member? "1" movetext [ draw-arc-to target ]       ; t1

      if member? "2" movetext [                            ; t2
        draw-arc-to g1
        repeat 45 [ fd degree-step                         ; rotate 45
            ifelse member? "R" movetext [right 1] [left 1]
            ifelse member? "L" movetext [left 1] [right 1] ]
        draw-arc-to target ]

      if member? "3" movetext [                            ; t3
        draw-arc-to g1
        repeat 90 [ fd degree-step                         ; rotate 90
            ifelse member? "R" movetext [right 1] [left 1]
            ifelse member? "L" movetext [left 1] [right 1] ]
        draw-arc-to target ]

      if member? "4" movetext [                          ; t4
        draw-arc-to g1
        repeat 135 [ fd degree-step                         ; rotate 135
            ifelse member? "R" movetext [right 1] [left 1]
            ifelse member? "L" movetext [left 1] [right 1] ]
        draw-arc-to target ]

    ; any t5 would go here.
    ]

  set pos [pos] of target setxy [xcor] of target [ycor] of target set heading [heading] of target ]
end




to d [target]
  let movetext [move] of target
  let radius matrix_size * sqrt(2) / 4
  let circ (pi * radius * 2)                          ; circumference
  let degree-step (circ / 360)                        ; step per degree of turn
  let tx [xcor] of target let ty [ycor] of target let th [heading] of target
  if (degree-step > 10) or (degree-step < 0)  [print (word "Bad Arc! degree-step: " precision degree-step 2 ) stop]

  ask thehand [

  ifelse color-by-move [ set color draw-color ] [ set color draw-color ]

  if member? "1" movetext [ fd matrix_size ]                       ; d1
  if member? "2" movetext [ draw-arc-to target ]                   ; d2

  if member? "3" movetext                                          ; d3
    [if member? "R" movetext [
       hatch-guides 1 [ pu rt 45 fd matrix_size * sqrt(2) / 2 lt 90 fd matrix_size * sqrt(2) / 4 rt 90 set pos "g1"]
       hatch-guides 1 [ pu rt 45 fd matrix_size * sqrt(2) / 2       fd matrix_size * sqrt(2) / 4 lt 90 set pos "g2"] ]
     if member? "L" movetext [
       hatch-guides 1 [ pu lt 45 fd matrix_size * sqrt(2) / 2 rt 90 fd matrix_size * sqrt(2) / 4 lt 90 set pos "g1"]
       hatch-guides 1 [ pu lt 45 fd matrix_size * sqrt(2) / 2       fd matrix_size * sqrt(2) / 4 rt 90 set pos "g2"] ]
      let g1 one-of guides with [pos = "g1"]
      let g2 one-of guides with [pos = "g2"]

      draw-arc-to g1                                               ; draw d3
      repeat 90 [ fd degree-step  if member? "R" movetext [right 1]  if member? "L" movetext [left 1]  ]
      pu setxy tx ty set heading th rt 180 pd
      draw-arc-to g2
      pu setxy tx ty set heading th pd]

  if member? "4" movetext                                          ; d4
    [if member? "R" movetext [
       hatch-guides 1 [pu rt 45 fd matrix_size * sqrt(2) / 2 lt 90 fd matrix_size * sqrt(2) / 4 rt 90 set pos "g1"]
       hatch-guides 1 [pu rt 45 fd matrix_size * sqrt(2) / 2 rt 90 fd matrix_size * sqrt(2) / 4 lt 90 set pos "g2"] ]
     if member? "L" movetext [
       hatch-guides 1 [pu lt 45 fd matrix_size * sqrt(2) / 2 rt 90 fd matrix_size * sqrt(2) / 4 lt 90 set pos "g1"]
       hatch-guides 1 [pu lt 45 fd matrix_size * sqrt(2) / 2 lt 90 fd matrix_size * sqrt(2) / 4 rt 90 set pos "g2"] ]
      let g1 one-of guides with [pos = "g1"]
      let g2 one-of guides with [pos = "g2"]

      draw-arc-to g1                                               ; draw d4
      repeat 180 [ fd degree-step if member? "R" movetext [right 1]  if member? "L" movetext [left 1]  ]
      draw-arc-to target ]

    set pos [pos] of target setxy [xcor] of target [ycor] of target set heading [heading] of target  ]
end



to o [target]
  let movetext [move] of target
  let posn [pos] of thehand
  let head [heading] of thehand
  let radius matrix_size * sqrt(2) / 4
  let circ (pi * radius * 2)                          ; circumference
  let degree-step (circ / 360)                        ; step per degree of turn
  if (degree-step > 10) or (degree-step < 0)  [print (word "Bad Arc! degree-step: " precision degree-step 2 ) stop]

  ifelse color-by-move [ ask thehand [ set color draw-color ] ] [ ask thehand [ set color draw-color ] ]

  ifelse member? "P" movetext [ let arc-size  67.5  ask thehand [
      let oldx xcor let oldy ycor let oldh heading
      fd matrix_size * sqrt(2) / 4
      repeat arc-size [fd degree-step
          if member? "Ov" posn [ ifelse head = 135 or head = 315 [right 1] [left  1] ]
          if member? "Oh" posn [ ifelse head = 135 or head = 315 [left  1] [right 1] ] ]
      fd matrix_size * 1.0  set pos [pos] of target
      pu
      setxy oldx oldy set heading oldh pd
      if member? "Ov" posn [ ifelse head = 135 or head = 315 [right 90] [left  90] ]
      if member? "Oh" posn [ ifelse head = 135 or head = 315 [left  90] [right 90] ]

      fd matrix_size * sqrt(2) / 4
      repeat arc-size [fd degree-step
          if member? "Ov" posn [ ifelse head = 135 or head = 315 [left  1] [right 1] ]
          if member? "Oh" posn [ ifelse head = 135 or head = 315 [right 1] [left  1] ] ]
      fd matrix_size * 1.0  set pos [pos] of target
      pu
      setxy oldx oldy set heading oldh pd
      if member? "Ov" posn [ ifelse head = 135 or head = 315 [left  90] [right 90] ]
      if member? "Oh" posn [ ifelse head = 135 or head = 315 [right 90] [left 90] ]
           ]  ]

  [let arc-size 0
  if member? "2" movetext [ set arc-size  90 ]
  if member? "3" movetext [ set arc-size 180 ]
  if member? "4" movetext [ set arc-size 270 ]

  ask thehand [fd matrix_size * sqrt(2) / 4]
  ask thehand [repeat arc-size [fd degree-step
          if member? "Ov" posn [ ifelse head = 135 or head = 315 [right 1] [left 1]  ]
          if member? "Oh" posn [ ifelse head = 135 or head = 315 [left 1]  [right 1] ] ] ]
  ask thehand [fd matrix_size * sqrt(2) / 4  set pos [pos] of target] ]

end



to h [target]
  let movetext [move] of target
  let posn [pos] of thehand
  let head [heading] of thehand
  let radius matrix_size * sqrt(2) / 4
  let circ (pi * radius * 2)                          ; circumference
  let degree-step (circ / 360)                        ; step per degree of turn
  if (degree-step > 10) or (degree-step < 0)  [print (word "Bad Arc! degree-step: " precision degree-step 2 ) stop]

  ifelse color-by-move [ ask thehand [ set color draw-color ] ] [ ask thehand [ set color draw-color ] ]

  ask thehand [
     hatch-guides 1 [ dress-thyself  fd matrix_size * sqrt(2) / 2        ; create another O3 guide
     if member? "Oh" posn  [ repeat 2
         [ ifelse head = 135 or head = 315 [left 90] [right 90] fd matrix_size * sqrt(2) / 2 ]
         set pos "Ov" ]
     if member? "Ov" posn  [ repeat 2
         [ ifelse head = 135 or head = 315 [right 90] [left 90] fd matrix_size * sqrt(2) / 2 ]
         set pos "Oh" ]  set move "HO3" ]

     let oldx xcor let oldy ycor let oldh heading
     let h3guide nobody

     if member? "R" movetext [ set h3guide one-of guides with [ move = "H3R" ] ]
     if member? "L" movetext [ set h3guide one-of guides with [ move = "H3L" ] ]
     draw-arc-to h3guide

     set heading oldh
     if member? "R" movetext [
     if member? "Ov" posn [ ifelse head = 135 or head = 315 [left  135] [right 270] ]
     if member? "Oh" posn [ ifelse head = 135 or head = 315 [right 270] [left  135] ] ]

     if member? "L" movetext [
     if member? "Ov" posn [ ifelse head = 135 or head = 315 [left  270] [right 135] ]
     if member? "Oh" posn [ ifelse head = 135 or head = 315 [right 135] [left  270] ] ]

     let O3guide one-of guides with [ move = "HO3" ]
     draw-arc-to O3guide
     setxy [xcor] of O3guide [ycor] of O3guide set heading [heading] of O3guide set pos [pos] of O3guide
     ask guides [die]     ]


end




; ######################################## SERVICES ##################################################
; ######################################## SERVICES ##################################################
; ######################################## SERVICES ##################################################



to dress-thyself ; guides only
    set color black  pen-up set size 3 ;set size max list 5 matrix_size / 5  pen-up set shape "circle"
end



to display-sequence   ;use this to cut C moves out into their own loops?
  clear-output
  let y-times 1
  ifelse verbose? = TRUE
    [repeat length sequence
      [ output-print (word "Loop " y-times ":" )
        let templist item (y-times - 1) sequence
        foreach templist [ [?1] -> output-type word ?1 " " ]
        set y-times y-times + 1
        output-print ""] ]
    [foreach sequence [ [?1] -> output-write ?1 output-print "" ] ]
end

to next-loop
;clean empty loops out of sequence
  foreach sequence [ [?1] -> if empty? ?1 [ set sequence remove ?1 sequence ] ]
  set sequence lput [] sequence
  set loops length sequence
  display-sequence
  set phase "move"
  ask guides [die]
end



to draw-arc-to [target]      ;same as v4
  let dist 0                                          ; set up variables
  let radius 0
  let arc-angle 0
  let dist-probe 0
  ask thehand [set dist (distance target) ]               ; collect basic information
  let delta-h subtract-headings [heading] of target [heading] of thehand  ; (-) if c-clockwise
  ask thehand [fd 1 set dist-probe (distance target) bk 1]

  set dist-probe dist - dist-probe                    ; set CASES
  let case ""
  ifelse dist-probe < 0
      [ifelse delta-h < 0                             ; then it's a big (>180) angle
          [set case "CW-big   "]
          [set case "CCW-big  "]]
      [ifelse delta-h < 0                             ; then it's a small (<180) angle
          [set case "CCW-small"]
          [set case "CW-small "]]

      let tangent-heading [heading] of thehand           ; collect headings
  ask thehand [face target]
      let target-heading [heading] of thehand
  ask thehand [set heading tangent-heading               ; measure "Angle-C"
      if member? "big" case [rt 180]
      ifelse member? "CCW" case [lt 90] [rt 90] ]
      let center-heading [heading] of thehand
  ask thehand [set heading tangent-heading]              ; reset heading
      let angle-C abs (subtract-headings center-heading target-heading)

  ifelse member? "small" case                         ; calculate radius
      [set radius (dist / 2) / cos(angle-C)]
      [set radius -1 * (dist / 2) / cos(angle-C * -1)]

  let turn 1                                          ; turn
  let circ (pi * radius * 2)                          ; circumference
  let degree-step (circ / 360)                        ; step per degree of turn
  if (degree-step > 10) or (degree-step < 0)
      [print (word "Bad Arc! degree-step: " precision degree-step 2 ) stop]

  set arc-angle 2 * (90 - angle-C)                    ; number of degrees to turn
  if member? "big" case
      [set arc-angle arc-angle + 360]
  ;print (word case "    Radius: " precision radius 2 "   Arc-angle: " precision arc-angle 2  "   Degree-step: " precision degree-step 2 )

   repeat arc-angle [ ask thehand                        ; draw the arc
       [ fd (degree-step)
         ifelse member? "CCW" case [lt 1] [rt 1] ]  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
219
15
779
576
-1
-1
5.16
1
10
1
1
1
0
1
1
1
0
106
0
106
0
0
0
ticks
30.0

BUTTON
20
84
105
152
Go
go-guides
T
1
T
OBSERVER
NIL
G
NIL
NIL
1

INPUTBOX
13
380
218
440
Kolam-Name
Fig3a2
1
0
String

BUTTON
107
84
192
152
Move
ask guides [die]\nset phase \"move\"
NIL
1
T
OBSERVER
NIL
M
NIL
NIL
1

BUTTON
788
565
843
598
Layout
ifelse any? links\n  [ ask links [ die ] ]\n  [ ask dots [ create-links-with other dots in-radius (matrix_size + 1)\n    [set color grey + 3] ] ]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

OUTPUT
19
604
902
733
10

TEXTBOX
59
176
168
208
Gesture Control
13
0.0
1

BUTTON
73
284
137
332
De-Spec
set key \"null\"\nhatchguides
NIL
1
T
OBSERVER
NIL
X
NIL
NIL
1

BUTTON
13
371
90
404
Save Kolam
save-kolam
NIL
1
T
OBSERVER
NIL
S
NIL
NIL
1

BUTTON
141
284
203
332
UNDO
undo
NIL
1
T
OBSERVER
NIL
U
NIL
NIL
1

BUTTON
140
195
203
228
R
set key \"R\"
NIL
1
T
OBSERVER
NIL
R
NIL
NIL
1

BUTTON
140
221
203
254
L
set key \"L\"
NIL
1
T
OBSERVER
NIL
L
NIL
NIL
1

BUTTON
140
247
203
280
C
set key \"C\"
NIL
1
T
OBSERVER
NIL
C
NIL
NIL
1

BUTTON
73
195
136
228
1
set key \"1\"
NIL
1
T
OBSERVER
NIL
1
NIL
NIL
1

BUTTON
73
208
136
241
2
set key \"2\"
NIL
1
T
OBSERVER
NIL
2
NIL
NIL
1

BUTTON
73
221
136
254
3
set key \"3\"
NIL
1
T
OBSERVER
NIL
3
NIL
NIL
1

BUTTON
73
234
136
267
4
set key \"4\"
NIL
1
T
OBSERVER
NIL
4
NIL
NIL
1

BUTTON
73
247
136
280
5
set key \"5\"
NIL
1
T
OBSERVER
NIL
5
NIL
NIL
1

BUTTON
14
195
69
228
ORTH
set key \"O\"
NIL
1
T
OBSERVER
NIL
O
NIL
NIL
1

BUTTON
14
221
69
254
DIAG
set key \"D\"
NIL
1
T
OBSERVER
NIL
D
NIL
NIL
1

BUTTON
14
247
69
280
TRAN
set key \"T\"
NIL
1
T
OBSERVER
NIL
T
NIL
NIL
1

BUTTON
94
371
177
404
Load Kolam...
load-kolam
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

INPUTBOX
787
24
1001
557
inserted-list
NIL
1
0
String

BUTTON
158
565
216
598
Refresh
set verbose? not verbose?\ndisplay-sequence
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
787
16
861
49
Append...
paste-moves FALSE
NIL
1
T
OBSERVER
NIL
A
NIL
NIL
1

BUTTON
864
16
948
49
Backwards...
paste-moves TRUE
NIL
1
T
OBSERVER
NIL
B
NIL
NIL
1

INPUTBOX
1049
854
1099
914
GPS
444
1
0
String

INPUTBOX
804
756
915
816
artist
FORMA
1
0
String

CHOOSER
935
886
1027
931
kolam-task
kolam-task
"-" "A" "B" "C" "D"
1

INPUTBOX
804
823
904
883
Kolam-Number
3.0
1
0
Number

SLIDER
20
14
192
47
Pulli
Pulli
2
29
8.0
1
1
NIL
HORIZONTAL

BUTTON
935
797
990
834
Task:
set Kolam-Name \"\"\nifelse kolam-task = \"-\" [set kolam-task \"A\"][\nifelse kolam-task = \"D\" [set kolam-task \"-\"][\nifelse kolam-task = \"C\" [set kolam-task \"D\"][\nifelse kolam-task = \"B\" [set kolam-task \"C\"][\nif kolam-task = \"A\" [set kolam-task \"B\"]]]]]\nset kolam-number 1\nset difficulty \"-\"\nsetup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1002
802
1070
835
Kolam:
set kolam-number kolam-number + 1\nset kolam-name \"\"\nset difficulty \"-\"\nsetup
NIL
1
T
OBSERVER
NIL
K
NIL
NIL
1

CHOOSER
931
745
1043
790
difficulty
difficulty
"-" "1 - Very Easy" "2 - Easy" "3 - Normal" "4 - Hard" "5 - Very Hard"
0

BUTTON
20
49
191
82
Restart
setup
NIL
1
T
OBSERVER
NIL
\
NIL
NIL
1

CHOOSER
805
892
897
937
initials
initials
"" "MK" "SB" "KA" "M" "A"
0

BUTTON
14
284
69
317
P
set key \"P\"
NIL
1
T
OBSERVER
NIL
P
NIL
NIL
1

BUTTON
14
299
69
332
H
set key \"H\"
NIL
1
T
OBSERVER
NIL
H
NIL
NIL
1

BUTTON
936
843
1031
876
New Artist
new-artist
NIL
1
T
OBSERVER
NIL
W
NIL
NIL
1

TEXTBOX
56
584
206
602
Kolam Sequence
12
0.0
1

INPUTBOX
14
443
169
503
draw-color
0.0
1
0
Color

@#$#@#$#@
## DATA COLLECTION VERSION 

Refinement  
- SAVING AND ITERATING PROCEDURES
	- always click on whitespace before saving
	- otherwise meta-data corruption and double-saves occur  
- make language bidirectionally readable 
	- R and L should be switched when going backwards
	- check position (Ov, Oh, D) before executing
	- this will allow a better "erase" and undo feature

New & Improved Moves  
- D3R and D3L have unsightly gaps  
- diagonal dots  
- a d3 point shape  
- an 03 point shape   
- a t2 horn shape  
- a O5 move (composed of a C1 and a O1)  
- square ortho moves

Other  
- sprout guides AFTER key?

## KOLAMS

Kolam patterns are a traditional Tamil art, and a type of visual prayer.  Many Tamil women will draw a Kolam pattern in the early morning on the threshold of the house.  Kolam patterns have a multifaceted set of meanings.  They are a beautiful form of art meant for apreciation.  They also signal that the woman has arranged the household affairs, and thus the quality, complexity, execution, and time of the kolam drawing can be a signal of the skill of the woman herself.  Kolam patterns also carry spiritual designations.  In general they mark the threshold of the house with a beautiful and auspicious blessing, a prayer for the house and those who live within it.  In addition individual Kolams may have special meaning and some are traditionally used during festivals such as Pongal or celebrations like marriages.  Kolams are traditionally not drawn for a period of days following a death in the family.  There are different types of Kolams, and related patterns that are used in this way, such as the Kambi Kolam, the pictoral Kolams, the Nelevu Kolam, and the north Indian Rangoli.  This program is designed to help study the "Nelevu Kolam," a curving pattern consisting of a number of loops drawn around a rectangular matrix of dots.

## KOLAM PROGRAM DOCUMENTATION

This program is designed to make the recording of "standard nelevu kolam" patterns easy and fast.  It provides a visual interface to construct kolams, and a number of tools that make the construction, storage and retrieval of kolam patterns simple.  The central purpose of the system is to encode kolam patterns as a series of moves to allow for a systematic comparison of patterns between kolams, women, regions, age groups, etc.

## FEATURES AND INSTRUCTIONS

Visual Entry -

Set the matrix_size slider and watch the "Grid Size" box on the right change.  This tells you how many dots wide (and tall) the final grid will be.  Click Reset.  Click "Go" or type "G" (most buttons have keyboard shortcuts for faster use).  Before you can begin drawing a kolam, you have to place your "hand" (the yellow arrowhead cursor).  Click and drag to place it (either in an orthogonal or diagonal position).  After you've let go, you will need to move the mouse to determine where to align the cursor, and click to finalize the heading.  The "orthogonal" and "diagonal" positions will allow you to align in different orientations:

>>>Two Positions each with Four Headings:  
Orth: 45, 135, 225, 315  
Diag:  0,  90, 180, 270

Now Guides will spawn.  The guides are little red arrowheads that you click on to execute a move.  When you mouseover a guide, it will display the move that it symbolizes.  Alternatively, you can type the name of that move.  The moves are below:

>>>Four Maneuver Classes  
Circle:	
      C1, C2, C3

Orthogonal:   O1, O2, O3, O4, (O5)  
Diagonal:
     D1, D2L, D2R, D3L, D3R, D4L, D4R

Transitional: T1L, T1R, T2L, T2R, T3L, T3R, T4L, T4R, (T5L, T5R)

- a circle (c1)  
- a star (c2)  
- a swastik (c3)

You can press "X" to "un-type" a partially selected move (e.g. if you typed "R" instead of "L", but haven't yet typed "D" or "4").  Transitional moves bridge the two standard set of moves (diagonal and orthogonal) by allowing a move to start in a an Orthogonal position and heading and end in a diagonal position or heading, or vice versa.

## LOOPS AND SEQUENCES

As you type or click to create your kolam pattern, the "Kolam Sequence" text area at the bottom of the interface will slowly grow.  Each move will be listed.  Kolams are made out of loops, and the program represents each Kolam as a list (the NetLogo equivalent of an array) of loops.  Each loop is also a list.  So the entire Kolam sequence, which is a list of lists of moves, will be updated in the text area as the Kolam grows.

Clicking "New Loop"(N) or drawing a circle (C) will create a new loop - a list into which new moves are added.  The system gives you the ability to undo any given move, delete loops, and to copy entire loops using the "Paste Loop..."(P) button.  This will replay the exact moves of the loop you select, starting from the current position and heading.  So, be sure your cursor is in the correct spot first, or you will end up with a pattern you didn't intend on!  If you do, though you can always use "Undo"(U) to remove all of the copied loop.

Finally, the program has the facility to save Kolams and load them from files.  Each Kolam is saved as two files with the same name - a text file ending in .txt and an image file ending in .png.  These will be automatically saved to the "Saved Kolams" folder in the same directory that the Kolam Program is located.  Be sure to also have an "Undo" folder there too, for the Undo feature to work.

## SUGGESTIONS FOR USE

If you are doing data entry (copying and sequencing 'real' Kolams found in the "wild", then I recommend proceeding carefully, and taking these points into consideration:

1) Know what you're going to do before you do it. - Knowing the Kolam you are entering will save you time.  How many loops does it have?  What type of symmetry?  Because the "Append..."(A) feature will allow you to copy lists of moves into the system, you can quickly build elaborate Kolams using very little work, if you are paying close attention.  Starting in the center is often a good idea.  Start in a part of a Kolam that doesn't feel like the middle of an aesthetically important part of the pattern.  Where ever you start, will be the beginning of the list of moves which constitutes that loop, so you could be "breaking up" important sequences.

2) Use the "Paste Loop..."(P) and "Append..."(A) and "Backwards..."(B) tools to build your Kolam quickly and not have to manually repeat every idential sequence.

In the future Kolam evolution experiments may be conducted a controlled laboratory setting.  In that situation, this program will be very valuable.  NetLogo has networking facilities, and will allow individuals to create and share Kolams in a structured social environment.  This will allow researchers to test theoretical questions about the forces of culture which influence the evolution of aesthetic design.

## QUESTIONS, COMMENTS

Author: Tim Waring (PhD Candidate, University of California, Davis)  
EMAIL: tmwaring@gmail.com  
Professional Website: http://www.xcelab.net/celab/?q=node/7  
Personal Website: http://tea-and-kate.blogspot.com/

## COPYRIGHT AND PERMISSION

Copyright: Tim Waring, 2009  
Permission: If you would like to use this program for any purpose beyond personal interest, please contact the author.  THIS PROGRAM MAY NOT, UNDER ANY CIRCUMSTANCES, BE USED FOR COMMERCIAL PURPOSES.  ALL RIGHTS RESERVED.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

link
true
0
Line -7500403 true 150 0 150 300

link direction
true
0
Line -7500403 true 150 150 30 225
Line -7500403 true 150 150 270 225

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.3.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
